/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - Ultima Printers                         **/
/**                                                                       **/
/**  MODULE NAME  : Info.cs                                               **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Text;
using System.Windows.Forms;
using System.Collections.Generic;
using SDKShim;

namespace CSharpDemo
{
    public partial class SDK_CSDemo : Form
    {
        #region === Local Methods ===

        private void InitInfoTab()
        {
			//No Specific Init required
        }

        private void ClearMsgBoxButton_Click(object sender, EventArgs e)
        {
            InfoMsgBox.Clear();
        }

        #endregion === Local Methods ===

        //----------------------------------------------------------------------

        #region === Printer Status ===

        private void PrinterStatusButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            string msg;
            switch (SDK.ID_PrinterStatus(hSession))
            {
            case SDK.PrinterStatus.Ready:   msg = "Printer is READY";       break;
            case SDK.PrinterStatus.Offline: msg = "Printer is OFFLINE";     break;
            case SDK.PrinterStatus.Error:   msg = "Printer is in ERROR";    break;
            default:                        msg = "Unknown Printer Status"; break;
            }
            InfoMsgBox.AppendText(msg + Environment.NewLine);
            InfoMsgBox.AppendText(Environment.NewLine);

            Cursor.Current = Cursors.Default;
        }

        #endregion === Printer Status ===

        //----------------------------------------------------------------------

        #region === Printer Info ===

        private void PrinterInfoButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            SDK.UltimaInfo PrinterInfo = new SDK.UltimaInfo();
            SDK.Return SDKReturn = SDK.ID_PrinterInfo(hSession, PrinterInfo);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("PrinterInfo", SDKReturn);
            }
            else
            {
                InfoMsgBox.AppendText("FirmwareVersion: "    + PrinterInfo.firmware_version            + Environment.NewLine);
                InfoMsgBox.AppendText("PrinterSerial: "      + PrinterInfo.printer_serial              + Environment.NewLine);
                InfoMsgBox.AppendText("ModelName: "          + PrinterInfo.model_name                  + Environment.NewLine);
                InfoMsgBox.AppendText("PrinterPartnerCode: " + PrinterInfo.printer_partner_code        + Environment.NewLine);
                InfoMsgBox.AppendText("CapabilityFlags: "    + PrinterInfo.capability_flags            + Environment.NewLine);
                InfoMsgBox.AppendText("Manufacturer: "       + PrinterInfo.manufacturer                + Environment.NewLine);
                InfoMsgBox.AppendText("TransferTargetTemp: " + PrinterInfo.transfer_target_temperature + Environment.NewLine);
                InfoMsgBox.AppendText("TransferActualTemp: " + PrinterInfo.transfer_actual_temperature + Environment.NewLine);

                InfoMsgBox.AppendText("TotalCards: "         + PrinterInfo.total_cards         + Environment.NewLine);
                InfoMsgBox.AppendText("TotalPanels: "        + PrinterInfo.total_panels        + Environment.NewLine);
                InfoMsgBox.AppendText("CardsOnPrinthead: "   + PrinterInfo.cards_on_printhead  + Environment.NewLine);
                InfoMsgBox.AppendText("PanelsOnPrinthead: "  + PrinterInfo.panels_on_printhead + Environment.NewLine);

                InfoMsgBox.AppendText("CardsLowLevel: "           + PrinterInfo.cards_low                 + Environment.NewLine);
                InfoMsgBox.AppendText("ColourName: "              + PrinterInfo.colour_name               + Environment.NewLine);
                InfoMsgBox.AppendText("ColourTotalPrints: "       + PrinterInfo.colour_total_prints       + Environment.NewLine);
                InfoMsgBox.AppendText("ColourPrintsRemaining: "   + PrinterInfo.colour_prints_remaining   + Environment.NewLine);
                InfoMsgBox.AppendText("ColourPartnerCode: "       + PrinterInfo.colour_partner_code       + Environment.NewLine);
                InfoMsgBox.AppendText("TransferName: "            + PrinterInfo.transfer_name             + Environment.NewLine);
                InfoMsgBox.AppendText("TransferTotalPrints: "     + PrinterInfo.transfer_total_prints     + Environment.NewLine);
                InfoMsgBox.AppendText("TransferPrintsRemaining: " + PrinterInfo.transfer_prints_remaining + Environment.NewLine);
                InfoMsgBox.AppendText("TransferPartnerCode: "     + PrinterInfo.transfer_partner_code     + Environment.NewLine);

                InfoMsgBox.AppendText("ErrorCode: "               + PrinterInfo.error_code    + Environment.NewLine);
                InfoMsgBox.AppendText("ErrorContext: "            + PrinterInfo.error_context + Environment.NewLine);

                InfoMsgBox.AppendText("CardsBetweenPrompts: "     + PrinterInfo.cards_between_prompts + Environment.NewLine);
                InfoMsgBox.AppendText("CleaningOverdue: "         + PrinterInfo.cleaning_overdue      + Environment.NewLine);
                InfoMsgBox.AppendText("CardsSinceClean: "         + PrinterInfo.cards_since_clean     + Environment.NewLine);
                InfoMsgBox.AppendText("PanelsSinceClean: "        + PrinterInfo.panels_since_clean    + Environment.NewLine);
                InfoMsgBox.AppendText("CleaningCycles: "          + PrinterInfo.cleaning_cycles       + Environment.NewLine);

                InfoMsgBox.AppendText("LaminateActualTemperature: " + PrinterInfo.laminate_actual_temperature + Environment.NewLine);
                InfoMsgBox.AppendText("LaminateTargetTemperature: " + PrinterInfo.laminate_target_temperature + Environment.NewLine);
                InfoMsgBox.AppendText("LaminateType: "              + PrinterInfo.laminate_type               + Environment.NewLine);
                InfoMsgBox.AppendText("CardSpeed: "                 + PrinterInfo.card_speed                  + Environment.NewLine);
                InfoMsgBox.AppendText(Environment.NewLine);
            }

            Cursor.Current = Cursors.Default;
        }

        #endregion === Printer Info ===

        //----------------------------------------------------------------------

        #region === SDK Version ===
        
        private void SDKVersionButton_Click(object sender, EventArgs e)
        {
            SDK.SDKVersion SDKVersion = new SDK.SDKVersion();

            SDK.Return SDKReturn = SDK.ID_SDKVersion(hSession, SDKVersion);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("SDKVersion", SDKReturn);
            }
            else
            {
                InfoMsgBox.AppendText("Version: " + SDKVersion.Major
                                      + "."       + SDKVersion.Minor
                                      + "."       + SDKVersion.Build
                                      + "."       + SDKVersion.Private
                                      + Environment.NewLine);
                InfoMsgBox.AppendText(Environment.NewLine);
            }
        }

        #endregion === SDK Version ===

        //----------------------------------------------------------------------

        #region === Connection Type ===

        private void ConnectionTypeButton_Click(object sender, EventArgs e)
        {
            string msg;
            switch (SDK.ID_ConnectionType(hSession))
            {
            case SDK.ConnectionType.USB:      msg = "USB";      break;
            case SDK.ConnectionType.Ethernet: msg = "Ethernet"; break;
            case SDK.ConnectionType.File:     msg = "File";     break;
            default:                          msg = "Unknown";  break;
            }
            InfoMsgBox.AppendText("Connection Type: " + msg + Environment.NewLine);
            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Connection Type ===

        //----------------------------------------------------------------------

        #region === Printer Type ===

        private void PrinterTypeButton_Click(object sender, EventArgs e)
        {
            InfoMsgBox.AppendText("Printer Type - ");
            switch (SDK.ID_PrinterType(hSession))
            {
            case SDK.PrinterType.Rio:
                InfoMsgBox.AppendText("RioTango" + Environment.NewLine);
                break;
            case SDK.PrinterType.AOTA:
                InfoMsgBox.AppendText("AOTA" + Environment.NewLine);
                break;
            case SDK.PrinterType.Enduro:
                InfoMsgBox.AppendText("Enduro Family" + Environment.NewLine);
                break;
            case SDK.PrinterType.Ultima:
                InfoMsgBox.AppendText("Ultima" + Environment.NewLine);
                break;
            case SDK.PrinterType.RioPro360:
                InfoMsgBox.AppendText("Rio Pro 360 Family" + Environment.NewLine);
                break;
            default:
                InfoMsgBox.AppendText("UNKNOWN" + Environment.NewLine);
                break;
            }
            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Printer Type ===

        //----------------------------------------------------------------------

        #region === Printer Model ===

        private void PrinterModelButton_Click(object sender, EventArgs e)
        {
            string msg;
            SDK.Model model = SDK.ID_PrinterModel(hSession);
            if (model.HasFlag(SDK.Model.Ultima))
                msg = "Ultima";

            else
                msg = "Unknown";
            InfoMsgBox.AppendText("Printer Model - " + msg + Environment.NewLine);

            InfoMsgBox.AppendText("Capability:" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Magnetic))
                InfoMsgBox.AppendText("  - Mag Encoding" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Duplex))
                InfoMsgBox.AppendText("  - Duplex" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Chip))
                InfoMsgBox.AppendText("  - Chip Encoding" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Contactless))
                InfoMsgBox.AppendText("  - Contactless Encoding" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Ethernet))
                InfoMsgBox.AppendText("  - Ethernet" + Environment.NewLine);
            if (model.HasFlag(SDK.Model.Fn_Laminate))
                InfoMsgBox.AppendText("  - Laminator" + Environment.NewLine);

            InfoMsgBox.AppendText(Environment.NewLine);
        }

        #endregion === Printer Model ===

        //----------------------------------------------------------------------

        #region === SDK Bits ===

        private void SDKBitsButton_Click(object sender, EventArgs e)
        {
            InfoMsgBox.AppendText(SDK.ID_SDKBits() + " Bit SDK" + Environment.NewLine + Environment.NewLine);
        }

        #endregion === SDK Bits ===

        //----------------------------------------------------------------------

        #region === Temperature ===

        private void TemperatureButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            bool status = false;
            SDK.Return SDKReturn = SDK.ID_Temperature(hSession, SDK.Temperature.Transfer, ref status);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("Temperature", SDKReturn);
            }
            else
            {
                InfoMsgBox.AppendText("Transfer Temperature: "
                                      + (status ? "Ready" : "Preheat")
                                      + Environment.NewLine
                                      + Environment.NewLine);
            }

            Cursor.Current = Cursors.Default;
        }

        #endregion === Temperature ===

        //----------------------------------------------------------------------

        #region === Last Message ===

        private void LastMessageButton_Click(object sender, EventArgs e)
        {
            StringBuilder Temp = new StringBuilder();
            SDK.Return SDKReturn = SDK.ID_LastMessage(hSession, Temp);
            if (SDKReturn != SDK.Return.Success)
            {
                HandleError("GetLastMessage", SDKReturn);
            }
            else
            {
                foreach (char c in Temp.ToString())
                {
                    InfoMsgBox.AppendText(c == '\n' ? Environment.NewLine : c.ToString());
                }
                InfoMsgBox.AppendText(Environment.NewLine);
                InfoMsgBox.AppendText(Environment.NewLine);
            }
        }

        #endregion === Last Message ===
    }
}
